//设置过滤条件默认值
var more_searchs = {
  //第一行条件
  searchKey: '', //搜索框的值
  //第二行条件
  country_value: '默认', //国家
  is_country: false, //精确国家
  city: '', //精确城市
  //第三行条件
  assign_source: '指定来源', //指定来源
  company_nature: '企业性质', //企业性质
  company_suffix: '公司后缀', //公司后缀
  is_filter: false, //过滤
  custom: false, //自定义
  custom_value: '', //自定义内容
  contact: false, //联系方式
  other_property: false, //其它属性
  other_property_value: '', //其它属性值
  syn:$('#synchronization').is(':checked')//判断是否同步
};

//第一行搜索条件
var searchType = 2; //查询类型/网站类型(默认显示bing搜索类型)

$(function() {
  // **********************界面公共方法相关**********************
  //加载界面初始化方法(点击界面其它位置时隐藏下拉框)
  init_doucmentClick();

  // **********************dom操作相关**********************
  //操作搜索栏显示还是隐藏方法
  contorl_searchBox();

  // **********************定时器相关**********************
  //初始化界面定时器(渲染界面)
  init_timer();

  // **********************表格数据相关**********************
  //渲染表格数据
  showTableData();

  // **********************pop界面和content-script界面公用的操作**********************
  //初始化相关操作方法
  init_popCommFunction();

  // 鹰眼一下搜索
  dispose_popBusiness();

  //设置默认模式
  $(".contact_deal").hide();
  setTimeout(function() {
    //加载搜索记录
    init_loadSearch();
    $("#plug_loading").hide();
  }, 300)
})

// 向content-script主动发送消息
function sendMessageToContentScript(message, callback) {
  chrome.tabs.query({
    active: true,
    currentWindow: true
  }, function(tabs) {
    chrome.tabs.sendMessage(tabs[0].id, message, function(response) {
      if (callback) callback(response);
    });
  });
}

/* 鹰眼一下进行搜索 */
function dispose_popBusiness() {
  // 鹰眼一下进行搜索(通用)
  $(document).on('click', '#searchBtn_friendList', function() {
    Friend_ExportBtn();
  });
}

/* 处理鹰眼一下按钮处理模式type(0:通用鹰眼一下  1:深挖客户  2:群组营销  3:人名查询联系方式) */
// function dispose_searchBtn(type) {
//   chrome.storage.local.get({
//     final_data: [], //数据
//     extensions_status: true, //插件状态
//   }, function(items) {
//     //判断插件是否启动
//     if (items.extensions_status == true) { //已启动
//       //判断抓取的数据表数据是否有数据
//       if (items.final_data.length > 0) { //有数据
//         layer.confirm('请确保数据已经保存，将清空原有数据！', {
//           btn: ['确定', '取消'] //按钮
//         }, function() {
//           //清除表格数据
//           chrome.storage.local.remove(['final_data'], function() {
//             // 设置程序状态为未开始
//             chrome.storage.local.set({
//               program_status: 0
//             }, function() {
//               sendMessageToContentScript({
//                 cmd: 'start_search',
//                 value: 'start_search'
//               }, function(response) {
//                 if (response == true) {
//                   console.log(
//                     '已关闭打开的搜索列表'
//                   );
//                 }
//                 console.log('来自content的回复:' +
//                   response);
//               });
//               // 执行搜索
//               start_searchData();
//             });
//           });
//         }, function() {
//           layer.msg('已取消', {
//             time: 1000, // 1s后自动关闭
//           });
//         });
//       } else { //无数据
//         //向content-script发送消息
//         sendMessageToContentScript({
//           cmd: 'start_search',
//           value: 'start_search'
//         }, function(response) {
//           console.log('鹰眼一下发送消息后来自content的回复：' + response);
//           //判断返回值信息
//           if (response == true) {
//             console.log('已关闭打开的搜索列表');
//           }
//         });
//         // 执行搜索
//         start_searchData();
//       }
//     } else { //未启动
//       layer.msg("请先启用插件", {
//         icon: 2
//       });
//     }
//   });
// }


/*好友导出页面鹰眼一下处理方法*/
function Friend_ExportBtn(){
	//判断类型
	type = $('#friendType').val();
	//领英数据类型
	if(type==2){
	//好友列表的网址
	nowUrl = 'https://www.linkedin.com/mynetwork/invite-connect/connections/';
	//拼接URL网址
	nowUrl = nowUrl + "#from_yys";
	//获取开始条数
	$start_page = Number($("#friendStartPage").val())
	if($start_page == ''){
		//当用户不输入起始和结束页，默认为0
		$start_page = 0;
	}

	//获取结束条数
	$end_page = Number($("#friendEndPage").val())
	if($end_page == ''){
		//当用户不输入起始和结束页，默认为0
		$end_page = 0;
	}

	//使用set写入
	if($start_page>$end_page){
		//判断起始页是否小于结束页面
		alert('输入有误，起始页必须小于结束页');
	}else{
	chrome.storage.local.set({
		//将起始页和结束页写入
		start_page:$start_page,
		end_page:$end_page,
	},function(){
		//打开领英好友列表的网页.
		window.open(nowUrl);
	})
	}
}

else if(type==1){
	nowUrl="https://www.facebook.com/friends/list";
	nowUrl = nowUrl+ "#from_yys";
	//获取开始条数
	$start_page = $("#friendStartPage").val()
	if($start_page == ''){
		//当用户不输入起始，默认为0
		$end_page = 0
	}
	//获取结束条数
	$end_page = $("#friendEndPage").val()
	if($end_page==''){
		//当用户不输入起始和结束页，默认为0
		alert('请输入结束条数');
	}
	
	//使用set写入
	if($start_page>$end_page){
		//判断起始页是否小于结束页面
		alert('输入有误，起始页必须小于结束页');
	}else{
	chrome.storage.local.set({
		//将起始页和结束页写入
		start_page:$start_page-1,
		end_page:$end_page,
	},function(){
		//打开FaceBook好友列表的网页.
		window.open(nowUrl);
	})
	}

}
}




/* 开始执行搜索方法  */
function start_searchData() {
  //判断网络连接状态
  if (!window.navigator.onLine) {
    layer.alert("网络连接不可用，请检查您的网络状态。");
    return;
  }
  console.log("开始执行搜索---------------");

  //获取设置的条件
  var conditionMsgResult = get_condition_msg().result; //获取条件是否正确
  var conditionMsg = {};
  //判断数据结构是否正确
  if (conditionMsgResult) {
    conditionMsg = get_condition_msg().conditionMsg;
  } else {
    return
  }

  //获取结束页/条
  let start = 1; //开始页
  let end = 1; //结束页
  if (searchType == 5) { //faceBook搜
    end = parseInt($('#end_number').val());
  } else {
    start = parseInt($('#start_page').val());
    end = parseInt($('#end_page').val());
  }

  //判断结束页不能小于开始页
  if (end < start) {
    layer.alert("结束页不能小于开始页!");
    return
  }

  // 定义需要移除的列表页参数:['是否停止','列表是否停止','最终状态','程序状态','当前处理数据下标']
  let needRemoveData = ['is_stop', 'list_stop', 'final_status', 'program_status', 'cur_index'];
  chrome.storage.local.remove(needRemoveData, function() {

    //移除完数据后存储界面数据
    chrome.storage.local.set({
      searchType: searchType, //当前搜索类型
      startAndEnd: [start, end, start], //结束页
      is_open: true,
      is_auto: $("#is_auto").is(':checked'), //是否自动
      search_time: $('#searchTime').val(), //翻页间隔时间
      detail_delay: $("#detail_delay").val(), //获取详情间隔时间
    })
    // 将获取的查询条件存入插件
    chrome.storage.local.set({
      now_deal_type: searchType, //网站类型
      setMoreSearchs: JSON.stringify(conditionMsg) //过滤条件
    }, function() {
      // 获取插件值
      chrome.storage.local.get({
        now_deal_type: 1,
        setMoreSearchs: {},
        startAndEnd: [], //结束页数据
      }, function(items) {
        //获取搜索链接
        var nowUrl = getSearchUrl(items.now_deal_type, items.setMoreSearchs);
        //***************获取分页信息***************
        let startPage = items.startAndEnd[0]; //开始页
        let endPage = items.startAndEnd[1]; //结束页

        // 判断搜索类型(获取url开始页)
        if (parseInt(items.now_deal_type) == 2) { //bing
          let startNum = ((startPage - 1) * 10) + 1;
          nowUrl = nowUrl + "&first=" + startNum;
        } else if (parseInt(items.now_deal_type) == 3) { //google
          let startNum = ((startPage - 1) * 10);
          nowUrl = nowUrl + "&start=" + startNum;
        } else if (parseInt(items.now_deal_type) == 4) { //Linkedin
          //nowUrl = nowUrl + "&page=" + startPage;
          nowUrl = "https://www.linkedin.com/mynetwork/invite-connect/connections/"
        } else if (parseInt(items.now_deal_type) == 5) { //Facebook
          //Facebook暂时无法获取
        } else if (parseInt(items.now_deal_type) == 6) { //googleMap
          //Google暂时无法获取
        }

        //拼接鹰眼搜插件打开标识
        nowUrl = nowUrl + "#from_yys"
        console.log(nowUrl);

        //将当前url存入
        chrome.storage.local.set({
          TotalThreadUrl: nowUrl,
          open_url_type: "yys_list"
        }, function() {
          //打开链接
          window.open(nowUrl);
        });
      })
    });
  });
}

/* 获取查询条件值 */
function get_condition_msg() {
  let result = true;
  // 定义条件对象
  let conditionMsg = {};

  //获取输入框的值
  conditionMsg.searchKey = $("#searchInput").val().trim();
  if (conditionMsg.searchKey == "") {
    layer.alert("请输入关键词");
    result = false;
  }
  //获取国家
  if ($(".yys-tips li.active span").eq(0).is(":visible")) {
    var countryVal = $(".yys-tips li.active span").eq(0).text();
    conditionMsg.country_value = countryVal;
  }
  //获取国家(商业数据源)
  if ($(".yys-tips .tip-li-source.active span").eq(0).is(":visible")) {
    var countryValSource = $(".yys-tips .tip-li-source.active span").eq(0).text();
    conditionMsg.country_value_source = countryValSource;
  }
  //获取是否精确国家
  if ($("#country").is(":visible")) {
    conditionMsg.is_country = $("#country").prop("checked");
  }
  //获取指定城市
  if ($("#city").is(":visible")) {
    conditionMsg.city = $("#city").val().trim();
  }
  //获取指定来源
  if ($("#sourceTitle").is(":visible")) {
    conditionMsg.assign_source = $("#sourceTitle").text().trim();
  }
  //获取企业性质
  if ($("#companyNatureListTitle").is(":visible")) {
    conditionMsg.company_nature = $("#companyNatureListTitle").text().trim();
  }
  //获取公司后缀
  if ($("#companySuffixTitle").is(":visible")) {
    conditionMsg.company_suffix = $("#companySuffixTitle").text().trim();
  }
  //过滤条件
  if ($("#filter").is(":visible")) {
    conditionMsg.is_filter = $("#filter").prop("checked");
  }
  //自定义
  if ($("#custom").is(":visible")) {
    conditionMsg.custom = $("#custom").prop("checked");
  }
  if ($("#customValue").is(":visible")) {
    conditionMsg.custom_value = $("#customValue").val();
  }
  //获取突破限制
  if ($("#break").is(":visible")) {
    conditionMsg.break = $("#break").prop("checked");
  }
  //获取google协同
  if ($("#synergy").is(":visible")) {
    conditionMsg.synergy = $("#synergy").prop("checked");
  }
  //联系方式
  if ($("#contact").is(":visible")) {
    conditionMsg.contact = $("#contact").prop("checked");
  }
  //其它属性
  if ($("#otherProperty").is(":visible")) {
    conditionMsg.other_property = $("#otherProperty").prop("checked");
  }
  if ($("#otherPropertyValue").is(":visible")) {
    conditionMsg.other_property_value = $("#otherPropertyValue").val().trim();
  }
  //国家属性
  if ($("#countryP").is(":visible")) {
    conditionMsg.country_property = $("#countryP").val();
  }
  //本国语
  if ($("#langeuage").is(":visible")) {
    conditionMsg.langeuage = $("#langeuage").prop("checked");
  }
  //数据源
  if ($("#business_source_val").is(":visible")) {
    conditionMsg.business_source_val = $("#business_source_val").val();
    if (conditionMsg.business_source_val == "") {
      layer.alert("请选择数据源");
      result = false;
    }
  }

  console.log("获取的过滤条件:");
  console.log(conditionMsg);
  let resultMsg = {
    result: result,
    conditionMsg: conditionMsg
  }
  return resultMsg;
}

/* 获取搜索链接地址(type:搜索类型 moreSeachs:更多搜索条件)  */
function getSearchUrl(type, moreSeachs) {
  console.log("获取url类型搜索类型:" + type);
  var url = ""; //地址

  //将传入的过滤条件解析成json格式
  var moreSeachs = JSON.parse(moreSeachs);

  //获取搜索框的值
  var keyword = "";

  //替换数据
  url = url.replace("\{keyword\}", keyword);
  console.log("获取的链接:");
  console.log(url);
  return url;
}

// 加载插件弹层页的搜索数据(上一次搜索记录)
function init_loadSearch() {
  chrome.storage.local.get({
    setMoreSearchs: {}, //搜索信息
    startAndEnd: [1, 1, 1], //开始和结束页
    final_data: [], //列表页数据
  }, function(items) {
    console.log(items);
    //解析获取过滤值
    var conditionObj = items.setMoreSearchs.length > 0 ? JSON.parse(items.setMoreSearchs) : more_searchs;

  })
}

// ******************************界面操作相关*******************************
/* 控制搜索栏显示还是隐藏(搜索条件框)  */
function contorl_searchBox() {
  // 点击搜索后关闭搜索
  chrome.storage.local.get({
    is_open: false,
    searchType: 2
  }, function(items) {
    //默认显示搜索框
    $(".header_search").css("display", "block");
    $('#open_search').css("display", "none");
    $('#close_search').css("display", "block");
  });

  // 关闭搜索
  $('#close_search').click(function() {
    $(".header_search").slideUp("slow", function() {
      $('#close_search').css("display", "none");
      $('#open_search').css("display", "block");
    });
  });

  // 展开搜索
  $('#open_search').click(function() {
    $(".header_search").slideDown("slow", function() {
      $('#close_search').css("display", "block");
      $('#open_search').css("display", "none");
    });
  });
}

/* 初始化界面点击事件方法(点击界面其它位置时隐藏下拉框)  */
function init_doucmentClick() {
  /* 绑定下拉列表互斥事件 */
  $(document).bind("click", function(e) {
    //************网站类型************
    if ($(e.target).closest("#searchTypeIcon").length == 0) {
      $("#more-search").hide();
    }
  })
}

// ******************************界面渲染相关*******************************
/* 初始化界面定时器(界面数据渲染相关) */
function init_timer() {
  var status_timer = setInterval(function() {
    // ********************抓取客户网站时的状态********************
    chrome.storage.local.get({
      program_status: 0,
    }, function(items) {
      //转换网站抓取状态类型
      var staus = parseInt(items.program_status);
      //判断列表页抓取状态(抓取完成后隐藏开始和暂停按钮)
      switch (staus) {
        case 0: //未开始
          $('#status1').css('background-color', 'orange').text('未开始');
          $('.btn_group1').css('display', 'inline-block');
          break;
        case 1:
          //获取列表抓取暂停状态
          chrome.storage.local.get({
            is_stop: true
          }, function(items) {
            //判断是否暂停
            if (items.is_stop) {
              $('#status1').css('background-color', 'red').text('暂停中');
            } else {
              $('#status1').css('background-color', 'red').text('查找客户中');
              $('.btn_group1').css('display', 'inline-block');
            }
          });
          break;
        case 2: //已找到客户
          $('#status1').css('background-color', '#00b436').text('已找到客户');
          $('.btn_group1').css('display', 'none');
          break;
      }
    });

    // ********************列表页数据********************
    // showTableData();

    // ********************客户信息处理时的状态********************
    chrome.storage.local.get({
      final_data: [], //列表数据
      list_stop: true, //列表是否暂停
    }, function(items) {
      //总记录数
      let totalLength = items.final_data.length;
      // 数据总条数
      $('#total_data_num').text(totalLength);

      //判断是否有数据
      if (totalLength > 0) {
        //获取未开始的数据
        let notStartLength = items.final_data.filter(item => item.linkState == -2).length;
        //获取处理中的数据
        let disposeLength = items.final_data.filter(item => item.linkState == 1).length;
        //已处理完成数量,除去(不抓取,未开始,处理中)
        let successLength = items.final_data.filter(item => ![-2].includes(item.linkState))
          .length;
        //设置已处理完成数量
        $('#now_deal_num').text(successLength);
        //判断数据处理状态
        if (successLength == totalLength) { //已处理完成数等于总数
          $('#status2').css('background-color', '#00b436').text('数据处理完毕');
        } else if (notStartLength == totalLength) { //未开始数等于总数
          $('#status2').css('background-color', 'orange').text('未开始');
        } else {
          $('#status2').css('background-color', 'red').text('数据处理中');
        }
      } else {
        $('#status2').css('background-color', 'orange').text('未开始');
      }
    })
  }, 200);
}

/* 初始化列表页相关操作方法 */
function init_operateTable() {
  // 全选
  $('#checkbox_all').on('click', function() {
    //获取所有列表复选框
    var b = $(".biYingTable tbody input[type='checkbox']");
    //定义是否全选
    var isAccCheck = $(this).prop('checked');

    //更新列表数据
    chrome.storage.local.get({
      final_data: [], //列表数据
    }, function(items) {
      //判断是否全选
      items.final_data.forEach((item, index) => {
        item.is_climb = isAccCheck;
      })

      //重新渲染表格
      resetTableData(items.final_data);
    })
  })
}

// *****************************列表页数据渲染相关*****************************
// 修改数据后重新渲染表格
function resetTableData(data) {
  chrome.storage.local.set({
    final_data: data
  }, function() {
    showTableData();
  });
}

// 渲染表格数据
function showTableData() {
  //获取列表数据
  chrome.storage.local.get({
    final_data: []
  }, function(items) {
    console.log(items.final_data);
    //获取数据
    var data = items.final_data;
    //获取条数
    var data_num = items.final_data.length;
    //获取需要拼接的容器
    var biYingTableBody = $('.biYingTable> table > tbody');
    //定义需要拼接的内容
    var html = '';
    if (data.length > 0) {
      for (var i = 0; i < data_num; i++) {
        // 处理状态
        var status;
        if (data[i].status == -3) {
          status = '<span style="color:#FF34B3;">超时</span>';
        } else if (data[i].status == -2) {
          status = '<span style="color:#0099ff;">不抓取</span>';
        } else if (data[i].status == -1) {
          status = '<span style="color:#0099ff;">失败</span>';
        } else if (data[i].status == 0) {
          status = '<span style="color:red;">未开始</span>';
        } else if (data[i].status == 1) {
          status = '<span style="color:#6666ff;">处理中</span>';
        } else if (data[i].status == 2) {
          status = '<span style="color:green;">已完成</span>';
        }

        var linkStatus;
        if(data[i].linkStatus == 0){
          linkStatus = '<span style="color:red;">待抓取</span>'
        } else if(data[i].linkStatus == 1){
          linkStatus = '<span style="color:#6666ff;">有官网</span>'
        } else if(data[i].linkStatus == -1 || data[i].linkStatus==""){
          linkStatus = '<span style="color:#FFF2366;">无官网</span>'
        }

        //处理同步状态
        var sync_status;
        if (data[i].sync_status == -1) {
          sync_status = '<span style="color:#0099ff;">失败</span>';
        } else if (data[i].sync_status == 0) {
          sync_status = '<span style="color:red;">未同步</span>';
        } else if (data[i].sync_status == 1) {
          sync_status = '<span style="color:#6666ff;">同步中</span>';
        } else if (data[i].sync_status == 2) {
          sync_status = '<span style="color:green;">已同步</span>';
        }
        
        var linkState;
        if (data[i].linkState == -1) {
          linkState = '<span style="color:#0099ff;">已完成</span>';
        }else if(data[i].linkState == -2){
          linkState = '<span style="color:red;">待开始</span>';
        }else if(data[i].linkState == -3){
          linkState = '<span style="color:#FF34B3;">超时</span>';
        }else if(data[i].linkState == -4){
          linkState = '<span style="color:blue;">失败</span>';
        }
        else{
          linkState = '<span style="color:red;">待开始</span>';
        }

        //处理选择状态
        var is_climb = data[i].is_climb;
        var html2 = '';
        //判断是否选中
        if (is_climb) {
          html2 = '<td><input class="listCheckbox" type="checkbox" now_index="' + i +
            '" checked></input><span>' + (i +
              1) + '</span></td>';
        } else {
          html2 = '<td><input class="listCheckbox" type="checkbox" now_index="' + i +
            '"></input><span>' + (i + 1) +
            '</span></td>';
        }

        //获取表格内容
        html += '<tr>' +
          html2 +
          '<td>' + data[i].title + '</td>' +
          '<td><a href="' + data[i].index_link + '" target="_blank">' + data[i].index_link + '</td>' +
          '<td>' + linkState + '</td>' +
          '<td>' + linkStatus + '</td>' +
          '<td class="list_del_btn"><button style="color:#fff;background-color:#666;border:none;border-radius:3px;" title="删除">x</button></td>' +
          '</tr>';
      }
    } else {
      html += '<tr>' +
        '<td colspan = "6">暂无数据</td>' +
        '</tr>';
    }
    //将处理好的html结构拼入内容
    biYingTableBody.html("");
    biYingTableBody.append(html);

    //初始化复选框方法
    listCheckBoxChange();
    //初始化数据删除方法
    delItemListData();
    //初始化列表页操作相关方法
    init_operateTable();
  });
}

/* 单个删除列表数据 */
function delItemListData() {
  $("#yys-plugin-table .list_del_btn").click(function() {
    //获取当前点击的元素下标
    let index = $("#yys-plugin-table .list_del_btn").index(this);
    //提示框
    layer.confirm('确定要删除吗？', {
      btn: ['确定', '取消'] //按钮
    }, function() {
      //更新数据
      chrome.storage.local.get({
        final_data: []
      }, function(items) {
        var temporaryDataArr = items.final_data;
        // 执行删除
        temporaryDataArr.splice(index, 1);
        //重新渲染表格
        resetTableData(temporaryDataArr);
      });

      layer.msg('已删除', {
        icon: 1
      });
    }, function() {
      layer.msg('已取消', {
        time: 1000, // 1s后自动关闭
      });
    });
  })
}

/* 列表复选框处理 */
function listCheckBoxChange() {
  //复选框改变事件
  $(".listCheckbox").change(function() {
    //获取所有复选框
    let $listCheckBox = $(".listCheckbox");
    //获取长度
    let length = $listCheckBox.length;
    //判断是否有值
    if (length > 0) {
      //未选中的数据下标
      let noCheckIndexArr = [];
      //循环处理
      for (let i = 0; i < length; i++) {
        //判断是否选中
        if (!$($listCheckBox[i]).is(":checked")) {
          noCheckIndexArr.push(i);
        }
      }

      //处理数据是否选中
      chrome.storage.local.get({
        final_data: [],
      }, function(items) {
        //循环将未选中的复选框处理
        items.final_data.forEach((item, index) => {
          if (noCheckIndexArr.includes(index)) {
            item.is_climb = false;
          } else {
            item.is_climb = true;
          }
        })

        //重新渲染表格
        resetTableData(items.final_data);
      })
    }
  })
}


// ***************************************pop界面和content-script界面公用的操作***************************************
// 初始化pop界面公共方法
function init_popCommFunction() {
  //*********************列表操作相关*********************
  // 清空列表数据
  $('#clear_list').click(function() {
    layer.confirm('确定要清空列表数据吗？', {
      btn: ['确定', '取消'] //按钮
    }, function() {
      //清空当前处理的数据下标
      chrome.storage.local.set({
        cur_index: 0, //当前处理的数据下标
      })
      //重新渲染表格数据
      resetTableData([]);
      layer.msg('列表数据已清空', {
        icon: 1
      });
    }, function() {
      layer.msg('已取消', {
        time: 1000, // 1s后自动关闭
      });
    });
  });

  //*********************详情操作相关*********************
  // 清空所有数据(底部清空)
  $('#clear_all').click(function() {
    layer.confirm('确定要清空所有数据吗？', {
      btn: ['确定', '取消'] //按钮
    }, function() {
      //清空所有数据
      chrome.storage.local.get(null, function(items) {
        //定义不清空的数据
        let noclearKey = ["is_tryOut", "login_info", "userInfo"];
        //获取所有除用户信息的key值
        let allKeyArr = [];
        for (i in items) {
          if (!noclearKey.includes(i)) {
            allKeyArr.push(i);
          }
        }

        //移除所有参数
        chrome.storage.local.remove(allKeyArr, function() {
          location.reload();
        });
      })
    }, function() {
      layer.msg('已取消', {
        time: 1000, // 1s后自动关闭
      });
    });
  });

  // 批量删除数据
  $('#list_del').click(function() {
    var $checkedId = []; //定义一个空数组
    var $chkBoxes = $('.biYingTable tbody').find('input:checkbox:checked'); //找到被选中的checkbox集

    // 遍历被选中的checkbox集
    $($chkBoxes).each(function() {
      //找到对应checkbox中 now_index 属性值，然后push给空数组$checkedId
      $checkedId.push(parseInt($(this).attr('now_index')));
    });

    if ($checkedId.length > 0) {
      layer.confirm('确定要批量删除吗？', {
        btn: ['确定', '取消'] //按钮
      }, function() {
        chrome.storage.local.get({
          final_data: []
        }, function(items) {
          var temporaryDataArr = items.final_data;
          // 遍历删除
          for (var j = $checkedId.length - 1; j >= 0; j--) {
            temporaryDataArr.splice($checkedId[j], 1);
          }
          // 重新保存
          chrome.storage.local.set({
            final_data: temporaryDataArr
          }, function() {
            //重新渲染表格
            showTableData();
            // $('.biYingTable > table > tbody').html('');
            layer.msg('已删除', {
              icon: 1
            });
          });
        });
      }, function() {
        layer.msg('已取消', {
          time: 1000, // 1s后自动关闭
        });
      });
    } else {
      layer.msg('请先选中要删除的数据', {
        icon: 2
      });
    }
  });
}

//*****************************其它公共方法*****************************
// 数组去重
function unique(now_arr) {
  if (!Array.isArray(now_arr)) {
    return '';
  }
  return [...new Set(now_arr)];
}

//获取域名方法
function getUrlDomain(link) {
  var domain = "";
  if (!!link) {
    //防止拷贝问题
    let url = JSON.parse(JSON.stringify(link));
    domain = url;
    //获取域名
    if (!!domain && domain.indexOf("/") != -1) {
      domain = url.split("/")[2];
    }

    //判断域名中是否有www
    if (!!domain && domain.indexOf("www.") != -1) { //有就去掉www.
      console.log(domain);
      domain = domain.substring(4, domain.length)
    }
  }
  return domain;
}
