//设置过滤条件默认值
var more_searchs = {
  //第一行条件
  searchKey: '', //搜索框的值
  //第二行条件
  country_value: '默认', //国家
  is_country: false, //精确国家
  city: '', //精确城市
  //第三行条件
  assign_source: '指定来源', //指定来源
  company_nature: '企业性质', //企业性质
  company_suffix: '公司后缀', //公司后缀
  is_filter: false, //过滤
  custom: false, //自定义
  custom_value: '', //自定义内容
  contact: false, //联系方式
  other_property: false, //其它属性
  other_property_value: '', //其它属性值
  message_value:"",//输入框的值
  filtration_cn_num:false,//过滤号码
};

//第一行搜索条件
var searchType = 3; //查询类型/网站类型(默认显示Gooele搜索类型)

$(function() {
  // **********************界面公共方法相关**********************
  //加载界面初始化方法(点击界面其它位置时隐藏下拉框)
  init_doucmentClick();

  // **********************dom操作相关**********************
  //操作搜索栏显示还是隐藏方法
  contorl_searchBox();

  // **********************定时器相关**********************
  //初始化界面定时器(渲染界面)
  init_timer();

  // **********************表格数据相关**********************
  //渲染表格数据
  showTableData();

  // **********************pop界面和content-script界面公用的操作**********************
  //初始化相关操作方法
  init_popCommFunction();

  // **********************国家数据相关**********************
  //获取国家数据信息
  get_countryData();
  //控制国家下拉列表显示
  control_showCountryList();
  //控制国家下拉列表选择
  control_checkCountryList();

  // 操作搜索类型
  intiSearchTypeOperate();

  // 鹰眼一下搜索
  dispose_popBusiness();

  //设置默认模式
  $(".contact_deal").hide();
  setTimeout(function() {
    //加载搜索记录
    init_loadSearch();
    $("#plug_loading").hide();
  }, 300)
})

/* 鹰眼一下进行搜索 */
function dispose_popBusiness() {
  // 鹰眼一下进行搜索(通用)
  $(document).on('click', '#searchBtn', function() {
    dispose_searchBtn();
  });

  // 清空搜索记录
  $("#clear_search").click(function() {
    layer.confirm('确定要清空搜索记录吗？', {
      btn: ['确定', '取消'] //按钮
    }, function() {
      chrome.storage.local.remove("setMoreSearchs", function() {
        chrome.storage.local.remove("is_open", function() {
          location.reload();
        });
      });
    }, function() {
      layer.msg('已取消', {
        time: 1000, // 1s后自动关闭
      });
    });
  });
}

/* 处理鹰眼一下按钮处理模式type(0:通用鹰眼一下  1:深挖客户  2:群组营销  3:人名查询联系方式) */
function dispose_searchBtn(type) {
  chrome.storage.local.get({
    final_data: [], //数据
    extensions_status: true, //插件状态
  }, function(items) {
    //判断插件是否启动
    if (items.extensions_status == true) { //已启动
      //判断抓取的数据表数据是否有数据
      if (items.final_data.length > 0) { //有数据
        layer.confirm('请确保数据已经保存，将清空原有数据！', {
          btn: ['确定', '取消'] //按钮
        }, function() {
          //清除表格数据
          chrome.storage.local.remove(['final_data'], function() {
            // 设置程序状态为未开始
            chrome.storage.local.set({
              program_status: 0,
            }, function() {
              sendMessageToContentScript({
                cmd: 'start_search',
                value: 'start_search'
              }, function(response) {
                if (response == true) {
                  console.log(
                    '已关闭打开的搜索列表'
                  );
                }
                console.log('来自content的回复:' +
                  response);
              });
              // 执行搜索
              start_searchData();
            });
          });
        }, function() {
          layer.msg('已取消', {
            time: 1000, // 1s后自动关闭
          });
        });
      } else { //无数据
        //向content-script发送消息
        sendMessageToContentScript({
          cmd: 'start_search',
          value: 'start_search'
        }, function(response) {
          console.log('鹰眼一下发送消息后来自content的回复：' + response);
          //判断返回值信息
          if (response == true) {
            console.log('已关闭打开的搜索列表');
          }
        });
        // 执行搜索
        start_searchData();
      }
    } else { //未启动
      layer.msg("请先启用插件", {
        icon: 2
      });
    }
  });
}

/* 开始执行搜索方法  */
function start_searchData() {
  //判断网络连接状态
  if (!window.navigator.onLine) {
    layer.alert("网络连接不可用，请检查您的网络状态。");
    return;
  }
  console.log("开始执行搜索---------------");

  //获取设置的条件
  var conditionMsgResult = get_condition_msg().result; //获取条件是否正确
  var conditionMsg = {};
  //判断数据结构是否正确
  if (conditionMsgResult) {
    conditionMsg = get_condition_msg().conditionMsg;
  } else {
    return
  }


  //获取结束页/条
  let start = 1; //开始页
  let end = 1; //结束页
  if (searchType == 5) { //faceBook搜
    end = parseInt($('#end_number').val());
  } else {
    start = parseInt($('#start_page').val());
    end = parseInt($('#end_page').val());
  }

  //判断结束页不能小于开始页
  if (end < start) {
    layer.alert("结束页不能小于开始页!");
    return
  }
  
  conditionMsg.filtration_cn_num = $("#is_filter_china").prop("checked");

  // 定义需要移除的列表页参数:['是否停止','列表是否停止','最终状态','程序状态','当前处理数据下标']
  let needRemoveData = ['is_stop', 'list_stop', 'final_status', 'program_status', 'cur_index'];
  chrome.storage.local.remove(needRemoveData, function() {

    //移除完数据后存储界面数据
    chrome.storage.local.set({
      searchType: searchType, //当前搜索类型
      startAndEnd: [start, end, start], //结束页
      is_open: true,
      is_auto: $("#is_auto").is(':checked'), //是否自动
      search_time: $('#searchTime').val(), //翻页间隔时间
      detail_delay: $("#detail_delay").val(), //获取详情间隔时间
      filtration_cn_num:$("#is_filter_china").is(':checked')//是否过滤号码
    })
    // 将获取的查询条件存入插件
    chrome.storage.local.set({
      now_deal_type: searchType, //网站类型
      setMoreSearchs: JSON.stringify(conditionMsg) //过滤条件
    }, function() {
      // 获取插件值
      chrome.storage.local.get({
        now_deal_type: 1,
        setMoreSearchs: {},
        startAndEnd: [], //结束页数据
      }, function(items) {
        //获取搜索链接
        var nowUrl = getSearchUrl(items.now_deal_type, items.setMoreSearchs);
        //***************获取分页信息***************
        let startPage = items.startAndEnd[0]; //开始页
        let endPage = items.startAndEnd[1]; //结束页

        // 判断搜索类型(获取url开始页)
        let startNum = ((startPage - 1) * 10);
        nowUrl = nowUrl + "&start=" + startNum;
        

        //拼接鹰眼搜插件打开标识
        nowUrl = nowUrl + "#from_yys"
        console.log(nowUrl);

        //将当前url存入
        chrome.storage.local.set({
          TotalThreadUrl: nowUrl,
          open_url_type: "yys_list",
          friend_type:2
        }, function() {
          //打开链接
          window.open(nowUrl);
        });
      })
    });
  });
}

/* 获取查询条件值 */
function get_condition_msg() {
  let result = true;
  // 定义条件对象
  let conditionMsg = {};

  //获取文本框的值
  conditionMsg.message_value = $(".message_template").val();

  //获取输入框的值
  conditionMsg.searchKey = $("#searchInput").val().trim();
  if (conditionMsg.searchKey == "") {
    layer.alert("请输入关键词");
    result = false;
  }
  //获取国家
  if ($(".yys-tips li.active span").eq(0).is(":visible")) {
    var countryVal = $(".yys-tips li.active span").eq(0).text();
    conditionMsg.country_value = countryVal;
  }
  //获取是否精确国家
  if ($("#country").is(":visible")) {
    conditionMsg.is_country = $("#country").prop("checked");
  }
  //获取指定城市
  if ($("#city").is(":visible")) {
    conditionMsg.city = $("#city").val().trim();
  }
  //获取指定来源
  if ($("#sourceTitle_whatsapp").is(":visible")) {
    conditionMsg.assign_source = $("#sourceTitle_whatsapp").text().trim();
  }
  //获取企业性质
  if ($("#companyNatureListTitle").is(":visible")) {
    conditionMsg.company_nature = $("#companyNatureListTitle").text().trim();
  }
  //获取公司后缀
  if ($("#companySuffixTitle").is(":visible")) {
    conditionMsg.company_suffix = $("#companySuffixTitle").text().trim();
  }
  //过滤条件
  if ($("#filter").is(":visible")) {
    conditionMsg.is_filter = $("#filter").prop("checked");
  } 
  //自定义
  if ($("#custom").is(":visible")) {
    conditionMsg.custom = $("#custom").prop("checked");
  }
  if ($("#customValue").is(":visible")) {
    conditionMsg.custom_value = $("#customValue").val();
  }
  //联系方式
  if ($("#contact").is(":visible")) {
    conditionMsg.contact = $("#contact").prop("checked");
  }
  //其它属性
  if ($("#otherProperty").is(":visible")) {
    conditionMsg.other_property = $("#otherProperty").prop("checked");
  }
  if ($("#otherPropertyValue").is(":visible")) {
    conditionMsg.other_property_value = $("#otherPropertyValue").val().trim();
  }


  console.log("获取的过滤条件:");
  console.log(conditionMsg);
  let resultMsg = {
    result: result,
    conditionMsg: conditionMsg
  }
  return resultMsg;
}

/* 获取搜索链接地址(type:搜索类型 moreSeachs:更多搜索条件)  */
function getSearchUrl(type, moreSeachs) {
  console.log("获取url类型搜索类型:" + type);
  var url = "https://www.google.com/search?q={keyword}"; //地址
  var filter = yysConfigs.searchFilter; //过滤条件(过滤广告)

  //将传入的过滤条件解析成json格式
  var moreSeachs = JSON.parse(moreSeachs);

  //获取搜索框的值
  var keyword = "";

  //获取国家(国家必须放在第一个)
  var countrySite = ""; //精确国家
  // 判断国家数据是否有值
  if (moreSeachs.country_value && moreSeachs.country_value.trim().length > 0) {
    //循环将所有国家设置搜索条件
    for (var i in yysConfigs.countryList) {
      if (yysConfigs.countryList[i].name == moreSeachs.country_value) {
          url = yysConfigs.countryList[i].google;
        if (moreSeachs.is_country && moreSeachs.is_country) { //精确国家
          countrySite = " site:" + yysConfigs.countryList[i].site;
          keyword += " " + countrySite;
        }
        break;
      }
    }
  }

  //判断指定来源
  if (moreSeachs.assign_source && moreSeachs.assign_source.trim() != "指定来源") {
    //判断具体来源
    if (moreSeachs.assign_source == "Linkedin") {
      keyword += " site:linkedin.com/company";
    } else if (moreSeachs.assign_source == "Zoom") {
      keyword += " site:zoominfo.com";
    } else if (moreSeachs.assign_source == "YP") {
      keyword += " site:yellowpages.com";
    } else if (moreSeachs.assign_source == "DNB") {
      keyword += " site:dnb.com/business";
    } else if (moreSeachs.assign_source == "FB") {
      keyword += " site:facebook.com";
    } else if (moreSeachs.assign_source == "Facebook") {
      keyword += " site:facebook.com";
    } else if (moreSeachs.assign_source == "Twitter") {
      keyword += " site:Twitter.com/";
    } else if (moreSeachs.assign_source == "instagram") {
      keyword += " site:instagram.com";
    } else if (moreSeachs.assign_source == "Pinterest") {
      keyword += " site:pinterest.com";
    } else if (moreSeachs.assign_source == "Tiktok") {
      keyword += " site:tiktok.com/@";
    } else if (moreSeachs.assign_source == "shopify") {
      keyword += " site:myshopify.com";
    } else if (moreSeachs.assign_source == "VK") {
      keyword += " site:vk.com";
    }
  }

  //获取输入框的值(关键词)
  keyword += ' "' + moreSeachs.searchKey + '"';

  //判断企业性质
  if (moreSeachs.company_nature && moreSeachs.company_nature.trim() != "企业性质") {
    if (moreSeachs.company_nature == "制造商") {
      keyword +=
        " (supplier OR suppliers OR supplying OR manufacture OR manufacturer OR manufacturers OR manufacturing OR mfg)";
    } else if (moreSeachs.company_nature == "贸易商") {
      keyword +=
        " (trade OR trader OR traders OR trading OR purchase OR purchaser OR purchasers OR purchasing OR import OR importer OR importers OR importing OR export OR exporter OR exporters  OR xporting OR exporters OR exporting)";
    } else if (moreSeachs.company_nature == "品牌商") {
      keyword += " (Brand OR Brand manufacturer)";
    } else if (moreSeachs.company_nature == "批发商") {
      keyword += " (wholesale OR wholesaler OR wholesalers OR wholesaling OR warehouse)";
    } else if (moreSeachs.company_nature == "经销商") {
      keyword +=
        " (distribute OR distributor OR distributors OR distribution OR distributing OR dealer OR agent OR broker)";
    } else if (moreSeachs.company_nature == "零售商") {
      keyword +=
        " (retailer OR store OR department Store OR supermarket OR Big box store OR chain store OR convenience store OR discount store OR discounter OR specialty store OR member club OR vendor OR online sales OR mail order OR tv shopping)";
    } else if (moreSeachs.company_nature == "下游服务商") {
      keyword += " (solution OR advice OR consultant)";
    }
  }
  // //判断过滤条件
  // if (moreSeachs.is_filter) {
  //   keyword += " " + filter;
  // }
  // //判断自定义条件(自定义过滤条件)
  // if (moreSeachs.custom) {
  //   keyword += " -" + moreSeachs.custom_value;
  // }
  // //判断公司后缀
  // if (moreSeachs.company_suffix && moreSeachs.company_suffix.trim() != "公司后缀") {
  //   keyword += " " + moreSeachs.company_suffix;
  // }
  //判断指定城市
  if (!!moreSeachs.city) {
    keyword += " " + moreSeachs.city;
  }
  // //判断其它属性
  // if (moreSeachs.other_property) {
  //   keyword += " +" + moreSeachs.other_property_value;
  // }
  //判断国家属性
  if (!!moreSeachs.country_property) {
    keyword += " +" + moreSeachs.country_property;
  }

  keyword += " " + "*wa.me/message OR *api.whatsapp.com/send";

  //替换数据
  url = url.replace("\{keyword\}", keyword);
  console.log("获取的链接:");
  console.log(url);
  return url;
}

// 加载插件弹层页的搜索数据(上一次搜索记录)
function init_loadSearch() {
  chrome.storage.local.get({
    searchType: 2, //网站类型
    setMoreSearchs: {}, //搜索信息
    startAndEnd: [1, 1, 1], //开始和结束页
    is_open: false, //是否开启
    is_auto: true, //是否自动
    search_time: 5, //翻页间隔时间
    final_data: [], //列表页数据
  }, function(items) {
    console.log(items);
    //解析获取过滤值
    var conditionObj = items.setMoreSearchs.length > 0 ? JSON.parse(items.setMoreSearchs) : more_searchs;
    console.log(conditionObj)
    //获取网站
    $("#more-search div").eq(0).click();
    
    // ***************操作方式***************
    //设置自动复选框是否选中
    $("#is_auto").attr("checked", items.is_auto);
    //设置结束条
    $('#start_page').val(items.startAndEnd[0]);
    $('#end_page').val(items.startAndEnd[1]);

    //设置翻页间隔时间
    $('#searchTime').val(items.search_time);

    // ***************过滤条件***************
    //获取输入框的值
    $("#searchInput").val(conditionObj.searchKey);
    //获取国家
    if (conditionObj.country_value == '默认') {
      //调用初始化精确国家方法
      init_sureCountry(1);
    } else {
      var selectLi = $('[nid="' + conditionObj.country_value + '"]');
      //调用初始化精确国家方法
      init_sureCountry();
      var text = selectLi.html();
      selectLi.parent().parent().addClass('active');
      selectLi.parent().siblings('.drop-title').children('.mySelect').html(text);
    }
    //获取输入框信息
    $(".message_template").val(conditionObj.message_value)
    //是否过滤号码
    $("#is_filter_china").attr("checked",conditionObj.filtration_cn_num)
    //获取是否精确国家
    $("#country").attr("checked", conditionObj.is_country);
    //获取指定城市
    $("#city").val(conditionObj.city);
    //获取指定来源
    $("#sourceTitle").text(conditionObj.assign_source);
    //获取企业性质
    $("#companyNatureListTitle").text(conditionObj.company_nature);
    //获取公司后缀
    $("#companySuffixTitle").text(conditionObj.company_suffix);
    //过滤条件
    $("#filter").attr("checked", conditionObj.is_filter);
    //自定义
    $("#custom").attr("checked", conditionObj.custom);
    $("#customValue").val(conditionObj.custom_value);
    //联系方式
    $("#contact").attr("checked", conditionObj.contact);
    //其它属性
    $("#otherProperty").attr("checked", conditionObj.other_property);
    $("#otherPropertyValue").val(conditionObj.other_property_value);
  })
}

// ***********************************界面操作相关***********************************
/* 初始化搜索类型点击 */
function intiSearchTypeOperate() {
  //*********网站类型*********
  $("#searchTypeIcon").on("click", function() {
    //根据是显示还是隐藏操作
    var element = $('#more-search');
    if (element.is(':hidden')) {
      element.show();
    } else {
      element.hide();
    }
  })
  $("#more-search div").on("click", function() {
    var val = $(this).html();

    //获取选择的下标类型数据
    var $searchtype = parseInt($(this).attr("type"));

    //根据权限判断是否可选数据源
    chrome.storage.local.get({
      userInfo: {}, //用户信息
    }, function(items) {
      if (items.userInfo.yys_member == 5) { //雏鹰
        //只能选择bing
        if ([3, 4, 5, 6, 7].includes($searchtype)) {
          layer.confirm('您的会员级别不权限使用当前功能，请升级更高版本。', {
            btn: ['立即购买'] //按钮
          }, function() {
            window.open(yysConfigs.buyYYsPagePath);
          })
          return
        }
      } else if (items.userInfo.yys_member == 6) { //金鹰
        //只能选择bing ,google,google地图
        if ([4, 5, 7].includes($searchtype)) {
          layer.confirm('您的会员级别不权限使用当前功能，请升级更高版本。', {
            btn: ['立即购买'] //按钮
          }, function() {
            window.open(yysConfigs.buyYYsPagePath);
          })
          return
        }
      }

      //获取类型
      searchType = $searchtype;

      //设置选中值
      $("#searchTypeTitle").html(val);

      // 第一行条件
      $("#searchFirst").show(); //总框
      $("#endNumber").hide(); //结束条
      $("#startPageBox").show(); //开始页
      $("#endPageBox").show(); //结束页
      //第二行条件
      $("#searchSecond").show(); //总框
      $("#searchSecondSource").hide(); //总框
      //显示群组营销条件(第三行)
      $("#search-other-yq").show(); //总框
      $("#country_property").hide();//国家属性
      $("#national_langeuage").hide();//本国语
      $("#custom_city_li").hide();//城市
      $("#source_customer_big").show();//指定来源
      $("#synergy_li").hide();//谷歌协同
      $("#break_li").hide();//突破限制
      $("#company_nature_li").show();//企业性质
      $("#company_suffix_li").show();//公司后缀
      $("#contact_li").show();//联系方式
      $("#filter_li").show();//过滤
      $("#custom_li").show();//自过滤
      $("#otherProperty_li").show();//其它属性
      $("#sourceList_whatsapp > li").eq(1).click();//默认指定来源为FaceBook.
    })
  })

  // *********WhatsApp营销*********
  // 指定来源
  $("#sourceTitle_whatsapp").on("click", function() {
    console.log(111);
  	//根据是显示还是隐藏操作
  	var element = $('#sourceList_whatsapp');
  	if (element.is(':hidden')) {
  		element.show();
  	} else {
  		element.hide();
  	}
  })
  $("#sourceList_whatsapp li").on("click", function() {
  	var val = $(this).html();
  	if (val == "不指定") {
  		$("#sourceTitle_whatsapp").html("指定来源" + "<img src='../image/next.png' title='展开' alt=''>");
  	} else {
  		$("#sourceTitle_whatsapp").html(val + "<img src='../image/next.png' title='展开' alt=''>");
  	}
  })

  //企业性质
  $("#companyNatureListTitle").on("click", function() {
    //根据是显示还是隐藏操作
    var element = $('#companyNatureList');
    if (element.is(':hidden')) {
      element.show();
    } else {
      element.hide();
    }
  })
  $("#companyNatureList li").on("click", function() {
    var val = $(this).html();
    if (val == "不指定") {
      $("#companyNatureListTitle").html("企业性质" + "<img src='../image/next.png' title='展开' alt=''>");
    } else {
      $("#companyNatureListTitle").html(val + "<img src='../image/next.png' title='展开' alt=''>");
    }
  })

  //公司后缀
  $("#companySuffixTitle").on("click", function() {
    //根据是显示还是隐藏操作
    var element = $('#companySuffix');
    if (element.is(':hidden')) {
      element.show();
    } else {
      element.hide();
    }
  })
  $("#companySuffix li").on("click", function() {
    var val = $(this).html();
    if (val == "不指定") {
      $("#companySuffixTitle").html("公司后缀" + "<img src='../image/next.png' title='展开' alt=''>");
    } else {
      $("#companySuffixTitle").html(val + "<img src='../image/next.png' title='展开' alt=''>");
    }
  })

  //过滤
  $("#filter").on("change", function() {
    //过滤与指定来源互斥
    if ($("#filter").prop('checked')) { //选中
      //互斥掉指定来源
      $("#no_source_cusbig").click();
      //互斥掉自定义
      $("#custom").attr("checked", false);
      $("#customValue").hide();
    }
  })

  //自定义
  $("#custom").on("change", function() {
    if ($("#custom").prop('checked')) { //选中
      //显示自定义框
      $("#customValue").show();
      //与指定来源互斥
      $("#no_source_cusbig").click();
      //与过滤互斥
      $("#filter").attr("checked", false);
    } else { //未选中
      $("#customValue").hide();
    }
  })

  //其它属性
  $("#otherProperty").on("change", function() {
    if ($("#otherProperty").prop('checked')) { //选中
      $("#otherPropertyValue").show();
    } else { //未选中
      $("#otherPropertyValue").hide();
    }
  })

  //精确国家
  $("#country").on("change", function() {
    //精确国家与指定来源互斥
    if ($("#country").prop('checked')) { //选中
      $("#no_source_cusbig").click();
    }
  })
}

/* 控制搜索栏显示还是隐藏(搜索条件框)  */
function contorl_searchBox() {
  // 点击搜索后关闭搜索
  chrome.storage.local.get({
    is_open: false,
    searchType: 2
  }, function(items) {
    //默认显示搜索框
    $(".header_search").css("display", "block");
    $('#open_search').css("display", "none");
    $('#close_search').css("display", "block");
  });

  // 关闭搜索
  $('#close_search').click(function() {
    $(".header_search").slideUp("slow", function() {
      $('#close_search').css("display", "none");
      $('#open_search').css("display", "block");
    });
  });

  // 展开搜索
  $('#open_search').click(function() {
    $(".header_search").slideDown("slow", function() {
      $('#close_search').css("display", "block");
      $('#open_search').css("display", "none");
    });
  });
}

/* 初始化界面点击事件方法(点击界面其它位置时隐藏下拉框)  */
function init_doucmentClick() {

  /* 绑定下拉列表互斥事件 */
  $(document).bind("click", function(e) {
    //************网站类型************
    if ($(e.target).closest("#searchTypeIcon").length == 0) {
      $("#more-search").hide();
    }

    // 指定来源
		if ($(e.target).closest("#sourceTitle_whatsapp").length == 0) {
			$("#sourceList_whatsapp").hide();
		}

    // 企业性质
		if ($(e.target).closest("#companyNatureListTitle").length == 0) {
			$("#companyNatureList").hide();
		}
		// 公司后缀
		if ($(e.target).closest("#companySuffixTitle").length == 0) {
			$("#companySuffix").hide();
		}
  })

}

// ******************************界面渲染相关*******************************
/* 初始化界面定时器(界面数据渲染相关) */
function init_timer() {
  var status_timer = setInterval(function() {
    // ********************抓取客户网站时的状态********************
    chrome.storage.local.get({
      program_status: 0,
    }, function(items) {
      //转换网站抓取状态类型
      var staus = parseInt(items.program_status);
      //判断列表页抓取状态(抓取完成后隐藏开始和暂停按钮)
      switch (staus) {
        case 0: //未开始
          $('#status1').css('background-color', 'orange').text('未开始');
          $('.btn_group1').css('display', 'inline-block');
          break;
        case 1:
          //获取列表抓取暂停状态
          chrome.storage.local.get({
            is_stop: true
          }, function(items) {
            //判断是否暂停
            if (items.is_stop) {
              $('#status1').css('background-color', 'red').text('暂停中');
            } else {
              $('#status1').css('background-color', 'red').text('查找客户中');
              $('.btn_group1').css('display', 'inline-block');
            }
          });
          break;
        case 2: //已找到客户
          $('#status1').css('background-color', '#00b436').text('已找到客户');
          $('.btn_group1').css('display', 'none');
          break;
      }
    });

    // ********************列表页数据********************
    // showTableData();

    // ********************客户信息处理时的状态********************
    chrome.storage.local.get({
      final_data: [], //列表数据
      list_stop: true, //列表是否暂停
    }, function(items) {
  
      //总记录数
      let totalLength = items.final_data.length;
      // 数据总条数
      $('#total_data_num').text(totalLength);

      //判断是否有数据
      if (totalLength > 0) {
        //获取未开始的数据
        let notStartLength = items.final_data.filter(item => item.status == 0).length;
        //获取处理中的数据
        let disposeLength = items.final_data.filter(item => item.status == 1).length;
        //已处理完成数量,除去(不抓取,未开始,处理中)
        let successLength = items.final_data.filter(item => ![-2, 0, 1].includes(item.status))
          .length;
        //设置已处理完成数量
        $('#now_deal_num').text(successLength);
        //判断数据处理状态
        if (successLength == totalLength) { //已处理完成数等于总数
          $('#status2').css('background-color', '#00b436').text('数据处理完毕');
        } else if (notStartLength == totalLength) { //未开始数等于总数
          $('#status2').css('background-color', 'orange').text('未开始');
        } else {
          $('#status2').css('background-color', 'red').text('数据处理中');
        }
      } else {
        $('#status2').css('background-color', 'orange').text('未开始');
      }
    })
  }, 200);
}

/* 初始化列表页相关操作方法 */
function init_operateTable() {
  // 全选
  $('#checkbox_all').on('click', function() {
    //获取所有列表复选框
    var b = $(".biYingTable tbody input[type='checkbox']");
    //定义是否全选
    var isAccCheck = $(this).prop('checked');

    //更新列表数据
    chrome.storage.local.get({
      final_data: [], //列表数据
    }, function(items) {
      //判断是否全选
      items.final_data.forEach((item, index) => {
        item.is_climb = isAccCheck;
      })

      //重新渲染表格
      resetTableData(items.final_data);
    })
  })
}


//一键营销的方法
function autoMarketing(){
  //定义字典
  let curWhatsapp = {
    //取得文本内容，用于拼接URL
    group_content:$(".message_template").val(),
    intterTime:$('.intervalTime').val()
  }
  console.log(curWhatsapp);
  if(curWhatsapp.intterTime<5){
    alert('延迟至少是五秒')
  }
  else{
    chrome.storage.local.get({
      final_data: [], //列表页数据
      cur_index: 0,//下标
    }, function(items) {
      //判断是否有数据
      if (items.final_data.length > 0) {
        select = []
        $('.listCheckbox').each(function(){
          select.push(this.checked)
        })
        let againLength = select.filter(function(res){return res==true}).length
        console.log(againLength)
        console.log(items.final_data[items.cur_index].index_link);
        //取出来源网址，将网址赋值给curWhatsapp中的source_url.
        curWhatsapp.source_url = items.final_data[items.cur_index].index_link;
        chrome.storage.local.set({
          //写入
          curWhatsapp: curWhatsapp,
          cur_index: 0,
          select:select,
          num:0
        }, function(items1) {
          bg.autoMessageSending();
          console.log('执行');       
        })
      }
    })
  }
}

// *****************************列表页数据渲染相关*****************************
// 修改数据后重新渲染表格
function resetTableData(data) {
  chrome.storage.local.set({
    final_data: data
  }, function() {
    showTableData();
  });
}

// 渲染表格数据
function showTableData() {
  //获取列表数据
  chrome.storage.local.get({
    final_data: []
  }, function(items) {
    // console.log(items.final_data);
    //获取数据
    var data = items.final_data;
    //获取条数
    var data_num = items.final_data.length;
    //获取需要拼接的容器
    var biYingTableBody = $('.biYingTable> table > tbody');
    //定义需要拼接的内容
    var html = '';
    if (data.length > 0) {
      for (var i = 0; i < data_num; i++) {
        // 处理状态
        var status;
        if (data[i].status == -3) {
          status = '<span style="color:#FF34B3;">超时</span>';
        } else if (data[i].status == -2) {
          status = '<span style="color:#0099ff;">不抓取</span>';
        } else if (data[i].status == -1) {
          status = '<span style="color:#0099ff;">失败</span>';
        } else if (data[i].status == 0) {
          status = '<span style="color:red;">未开始</span>';
        } else if (data[i].status == 1) {
          status = '<span style="color:#6666ff;">处理中</span>';
        } else if (data[i].status == 2) {
          status = '<span style="color:green;">已完成</span>';
        }

        //处理同步状态
        var sync_status;
        if (data[i].sync_status == -1) {
          sync_status = '<span style="color:#0099ff;">失败</span>';
        } else if (data[i].sync_status == 0) {
          sync_status = '<span style="color:red;">未同步</span>';
        } else if (data[i].sync_status == 1) {
          sync_status = '<span style="color:#6666ff;">同步中</span>';
        } else if (data[i].sync_status == 2) {
          sync_status = '<span style="color:green;">已同步</span>';
        }

        //处理官网状态
        var again_web_status;
        if (data[i].again_web_status == -3) {
          again_web_status = '<span style="color:#FF34B3;">超时</span>';
        } else if (data[i].again_web_status == -2) {
          again_web_status = '<span style="color:#0099ff;">无官网</span>';
        } else if (data[i].again_web_status == -1) {
          again_web_status = '<span style="color:#0099ff;">失败</span>';
        } else if (data[i].again_web_status == 0) {
          again_web_status = '<span style="color:red;">未开始</span>';
        } else if (data[i].again_web_status == 1) {
          again_web_status = '<span style="color:#6666ff;">处理中</span>';
        } else if (data[i].again_web_status == 2) {
          again_web_status = '<span style="color:green;">已完成</span>';
        }
        
        var aiMarketing;
        if (data[i].aiMarketing == -3) {
          aiMarketing = '<span style="color:#FF34B3;">超时</span>';
        } else if (data[i].aiMarketing == -2) {
          aiMarketing = '<span style="color:green;">已发送</span>';
        } else if(data[i].aiMarketing == -5){
          aiMarketing = '<span style="color:#0099ff;">无号码</span>';
        }
        else if(data[i].aiMarketing ==-1){
          aiMarketing = '<span style="color:#C71585;">号码无效</span>';
        }
        else if(data[i].aiMarketing ==0){
          aiMarketing = '<span style="color:red;">待处理</span>';
        }

        //处理选择状态
        var is_climb = data[i].is_climb;
        var html2 = '';
        //判断是否选中
        if (is_climb) {
          html2 = '<td><input class="listCheckbox" type="checkbox" now_index="' + i +
            '" checked></input><span>' + (i +
              1) + '</span></td>';
        } else {
          html2 = '<td><input class="listCheckbox" type="checkbox" now_index="' + i +
            '"></input><span>' + (i + 1) +
            '</span></td>';
        }

        //获取表格内容
        html += '<tr>' +
          html2 +
          '<td>' + data[i].title + '</td>' +
          '<td><a href="' + data[i].index_link + '" target="_blank">' + data[i].index_link + '</td>' +
          '<td>' + aiMarketing + '</td>' +
          // '<td>' + sync_status + '</td>' +
          // '<td>' + again_web_status + '</td>' +
          '<td class="list_del_btn"><button style="color:#fff;background-color:#666;border:none;border-radius:3px;" title="删除">x</button></td>' +
          '</tr>';
      }
    } else {
      html += '<tr>' +
        '<td colspan = "6">暂无数据</td>' +
        '</tr>';
    }
    //将处理好的html结构拼入内容
    biYingTableBody.html("");
    biYingTableBody.append(html);

    //初始化复选框方法
    listCheckBoxChange();
    //初始化数据删除方法
    delItemListData();
    //初始化列表页操作相关方法
    init_operateTable();
  });
}

/* 单个删除列表数据 */
function delItemListData() {
  $("#yys-plugin-table .list_del_btn").click(function() {
    //获取当前点击的元素下标
    let index = $("#yys-plugin-table .list_del_btn").index(this);
    //提示框
    layer.confirm('确定要删除吗？', {
      btn: ['确定', '取消'] //按钮
    }, function() {
      //更新数据
      chrome.storage.local.get({
        final_data: []
      }, function(items) {
        var temporaryDataArr = items.final_data;
        // 执行删除
        temporaryDataArr.splice(index, 1);
        //重新渲染表格
        resetTableData(temporaryDataArr);
      });

      layer.msg('已删除', {
        icon: 1
      });
    }, function() {
      layer.msg('已取消', {
        time: 1000, // 1s后自动关闭
      });
    });
  })
}

/* 列表复选框处理 */
function listCheckBoxChange() {
  //复选框改变事件
  $(".listCheckbox").change(function() {
    //获取所有复选框
    let $listCheckBox = $(".listCheckbox");
    //获取长度
    let length = $listCheckBox.length;
    //判断是否有值
    if (length > 0) {
      //未选中的数据下标
      let noCheckIndexArr = [];
      //循环处理
      for (let i = 0; i < length; i++) {
        //判断是否选中
        if (!$($listCheckBox[i]).is(":checked")) {
          noCheckIndexArr.push(i);
        }
      }

      //处理数据是否选中
      chrome.storage.local.get({
        final_data: [],
      }, function(items) {
        //循环将未选中的复选框处理
        items.final_data.forEach((item, index) => {
          if (noCheckIndexArr.includes(index)) {
            item.is_climb = false;
          } else {
            item.is_climb = true;
          }
        })

        //重新渲染表格
        resetTableData(items.final_data);
      })
    }
  })
}

// ***************************************pop界面和content-script界面公用的操作***************************************
// 初始化pop界面公共方法
function init_popCommFunction() {
  //*********************列表操作相关*********************
  // 清空列表数据
  $('#clear_list').click(function() {
    layer.confirm('确定要清空列表数据吗？', {
      btn: ['确定', '取消'] //按钮
    }, function() {
      //清空当前处理的数据下标
      chrome.storage.local.set({
        cur_index: 0, //当前处理的数据下标
      })
      //重新渲染表格数据
      resetTableData([]);
      layer.msg('列表数据已清空', {
        icon: 1
      });
    }, function() {
      layer.msg('已取消', {
        time: 1000, // 1s后自动关闭
      });
    });
  });

  //*********************详情操作相关*********************
  // 清空所有数据(底部清空)
  $('#clear_all').click(function() {
    layer.confirm('确定要清空所有数据吗？', {
      btn: ['确定', '取消'] //按钮
    }, function() {
      //清空所有数据
      chrome.storage.local.get(null, function(items) {
        //定义不清空的数据
        let noclearKey = ["is_tryOut", "login_info", "userInfo"];
        //获取所有除用户信息的key值
        let allKeyArr = [];
        for (i in items) {
          if (!noclearKey.includes(i)) {
            allKeyArr.push(i);
          }
        }

        //移除所有参数
        chrome.storage.local.remove(allKeyArr, function() {
          location.reload();
        });
      })
    }, function() {
      layer.msg('已取消', {
        time: 1000, // 1s后自动关闭
      });
    });
  });

  // 批量删除数据
  $('#list_del').click(function() {
    var $checkedId = []; //定义一个空数组
    var $chkBoxes = $('.biYingTable tbody').find('input:checkbox:checked'); //找到被选中的checkbox集

    // 遍历被选中的checkbox集
    $($chkBoxes).each(function() {
      //找到对应checkbox中 now_index 属性值，然后push给空数组$checkedId
      $checkedId.push(parseInt($(this).attr('now_index')));
    });

    if ($checkedId.length > 0) {
      layer.confirm('确定要批量删除吗？', {
        btn: ['确定', '取消'] //按钮
      }, function() {
        chrome.storage.local.get({
          final_data: []
        }, function(items) {
          var temporaryDataArr = items.final_data;
          // 遍历删除
          for (var j = $checkedId.length - 1; j >= 0; j--) {
            temporaryDataArr.splice($checkedId[j], 1);
          }
          // 重新保存
          chrome.storage.local.set({
            final_data: temporaryDataArr
          }, function() {
            //重新渲染表格
            showTableData();
            // $('.biYingTable > table > tbody').html('');
            layer.msg('已删除', {
              icon: 1
            });
          });
        });
      }, function() {
        layer.msg('已取消', {
          time: 1000, // 1s后自动关闭
        });
      });
    } else {
      layer.msg('请先选中要删除的数据', {
        icon: 2
      });
    }
  });

  // 导出数据
  $('#down_data').click(function() {
    chrome.storage.local.get({
      final_data: []
    }, function(items) {
      if (items.final_data.length > 0) {
        var now_data_list = items.final_data;
        for (var i = 0; i < now_data_list.length; i++) {
          var now_email_arr = now_data_list[i].email;
          var now_phone_arr = now_data_list[i].phone;

          function unique(now_arr) {
            if (!Array.isArray(now_arr)) {
              return '';
            }
            return [...new Set(now_arr)];
          }
          var now_email_arr = unique(now_email_arr);
          var now_phone_arr = unique(now_phone_arr);
          now_data_list[i].email = now_email_arr;
          now_data_list[i].phone = now_phone_arr;


          // 删除 contact 和 about 链接
          delete now_data_list[i].about_link;
          delete now_data_list[i].contact_link;
        }

        // 去重后重新保存
        chrome.storage.local.set({
          final_data: now_data_list
        }, function() {
          // 保存成功后将数据导出
          var jsono = [];
          chrome.storage.local.get({
            final_data: []
          }, function(items) {
            console.log(items.final_data);
            jsono = items.final_data;
            downloadExl(jsono);
            var tmpDown; //导出的二进制对象
            function downloadExl(json, type) {
              var tmpdata = json[0];
              json.unshift({});
              var keyMap = []; //获取keys
              //keyMap =Object.keys(json[0]);
              for (var k in tmpdata) {
                keyMap.push(k);
                json[0][k] = k;
              }
              var tmpdata = []; //用来保存转换好的json
              json.map((v, i) => keyMap.map((k, j) => Object.assign({}, {
                v: v[k],
                position: (j > 25 ? getCharCol(j) :
                  String
                  .fromCharCode(65 + j)) + (i + 1)
              }))).reduce((prev, next) => prev.concat(next)).forEach((
                v,
                i) => tmpdata[v.position] = {
                v: v.v
              });
              var outputPos = Object.keys(tmpdata); //设置区域,比如表格从A1到D10
              var tmpWB = {
                SheetNames: ['mySheet'], //保存的表标题
                Sheets: {
                  'mySheet': Object.assign({},
                    tmpdata, //内容
                    {
                      '!ref': outputPos[0] + ':' +
                        outputPos[
                          outputPos.length - 1
                        ] //设置填充区域
                    })
                }
              };
              tmpDown = new Blob([s2ab(XLSX.write(tmpWB, {
                  bookType: (type == undefined ?
                    'xlsx' :
                    type),
                  bookSST: false,
                  type: 'binary'
                } //这里的数据是用来定义导出的格式类型
              ))], {
                type: ""
              }); //创建二进制对象写入转换好的字节流
              var href = URL.createObjectURL(tmpDown); //创建对象超链接
              document.getElementById("hf").href = href; //绑定a标签
              document.getElementById("hf").click(); //模拟点击实现下载
              setTimeout(function() { //延时释放
                URL.revokeObjectURL(
                  tmpDown
                ); //用URL.revokeObjectURL()来释放这个object URL
              }, 100);
            }

            function s2ab(s) { //字符串转字符流
              var buf = new ArrayBuffer(s.length);
              var view = new Uint8Array(buf);
              for (var i = 0; i != s.length; ++i) view[i] = s.charCodeAt(
                  i) &
                0xFF;
              return buf;
            }
            // 将指定的自然数转换为26进制表示。映射关系：[0-25] -> [A-Z]。
            function getCharCol(n) {
              let temCol = '',
                s = '',
                m = 0
              while (n > 0) {
                m = n % 26 + 1
                s = String.fromCharCode(m + 64) + s
                n = (n - m) / 26
              }
              return s
            }

            layer.alert('数据已经导出');
          });
        });
      } else {
        layer.msg('暂无数据', {
          icon: 2
        });
      }
    });
  });
}

// **********************国家数据相关**********************
/* 获取国家数据信息 */
function get_countryData() {
  countryCheck('yz', '#drop-menu-yz'); //亚洲
  countryCheck('oz', '#drop-menu-oz'); //欧洲
  countryCheck('mz', '#drop-menu-mz'); //美洲
  countryCheck('dyz', '#drop-menu-dyz'); //大洋洲
  countryCheck('fz', '#drop-menu-fz'); //非洲
  // 显示国家
  function countryCheck(myCountry, id) {
    var myCountry = yysConfigs.countryMap[myCountry];
    var list = "";
    for (var i = 0, max = myCountry.length; i < max; i++) {
      var optionCountry = myCountry[i].name;
      var optionShorthand = myCountry[i].site;
      var yzList = ' <li class="typeslect" cid="' + optionShorthand + '" nid="' + optionCountry + '">' +
        optionCountry + '</li>';
      list += yzList;
    }
    $(id).html(list);
  };
}

//控制点击展开国家下拉数据操作
function control_showCountryList() {
  var li = $('.tip-li');
  for (var i = 0, max = li.length; i < max; i++) {
    (function(i) {
      li[i].addEventListener('click', function(e) {
        var child = $(this).children('.dropdown-menu');

        //根据会员级别判断是否可以切换国家
        chrome.storage.local.get({
          userInfo: {}, //用户信息
        }, function(items) {
          //金鹰,神鹰 才可选
          if ([6, 7].includes(items.userInfo.yys_member)) {
            if (child.is(':hidden')) {
              child.stop(true, false).show(200);
              $(this).siblings('.tip-li').children('.dropdown-menu').stop(true,
                false).hide(200);
            } else {
              child.stop(true, false).hide(200);
            }
            $(document).one('click', function() {
              $('.dropdown-menu').stop(true, false).hide(200);
            })
            //阻止事件冒泡触发事件导致隐藏
            e.stopPropagation();
          } else {
            layer.confirm('您的会员级别不权限使用当前功能，请升级更高版本。', {
              btn: ['立即购买'] //按钮
            }, function() {
              window.open(yysConfigs.buyYYsPagePath);
            })
          }
        })
      });
      //阻止点击内容时隐藏
      $('.dropdown-menu').on('click', function(e) {
        e.stopPropagation()
      })
    })(i)
  }
  // 点击国家下拉栏筛选
  $('#normalCountry').on('click', function() {
    //调用初始化精确国家方法
    init_sureCountry(1);
    $('.dropdown-menu').stop(true, false).hide(200);

    //获取城市数据
    yysConfigs.cityItems = yysConfigs.cityMap["中国大陆(简体中文)"];
    console.log(yysConfigs);
    //清空城市框内容
    $(".sure-city #city").val("");
  });
};

//控制切换国家下拉数据选择操作
function control_checkCountryList() {
  //获取选中的国家
  var li = $('.typeslect');
  for (var i = 0, max = li.length; i < max; i++) {
    (function(i) {
      li[i].addEventListener('click', function() {
        var searchWord = $("#searchInput").val().trim().toLowerCase();
        if (searchWord.startsWith("site:")) {
          $("body").tipAlert({
            title: '已使用了site:语法，请重新输入搜索内容。',
            noMsg: true
          });
          return;
        }
        //获取当前选择的国家cid
        var country = $(this).attr("cid");
        var countryVal = $(this).attr("nid");
        var text = $(this).html();
        //调用初始化国家方法
        init_sureCountry();
        //获取当前选中的国家
        $(this).parent().parent().addClass('active');
        $(this).parent().siblings('.drop-title').children('.mySelect').html(
          text);
        $('.dropdown-menu').stop(true, false).hide(200);

        // 选择国家样式
        chooseMmFont(country);
        //判断国家是否为空
        if (countryVal == '') { //为空获取所有
          yysConfigs.cityItems = yysConfigs.cityMap["中国大陆(简体中文)"];
        } else { //不为空获取指定
          yysConfigs.cityItems = yysConfigs.cityMap[countryVal];
          if (yysConfigs.cityItems.length > 0) {
            $(".sure-city #city").val(yysConfigs.cityItems[0].en_city);
          } else {
            $(".sure-city #city").val("");
          }
        }
        chrome.storage.local.set({
          setMoreSearchs: JSON.stringify(more_searchs)
        });
        //清空精确城市数据
        $(".sure-city #city").val("");
      })
    })(i)
  }
}

/* 初始化精确国家数据type(0/不传:无默认选择 1:选中默认)  */
function init_sureCountrySource(type) {
  $('#selSource1').html('亚洲');
  $('#selSource2').html('欧洲');
  $('#selSource3').html('美洲');
  $('#selSource4').html('大洋洲');
  $('#selSource5').html('非洲');
  $('.tip-li-source').removeClass('active');
  if (type == 1) {
    $('#normalCountrySource').addClass('active'); //选中默认
    //获取商业数据来源
    yysConfigs.sourceList = yysConfigs.defaultSourceList;
  }
}

//控制点击展开国家下拉数据操作
function control_showCountryListSource() {
  var li = $('.tip-li-source');
  for (var i = 0, max = li.length; i < max; i++) {
    (function(i) {
      li[i].addEventListener('click', function(e) {
        var child = $(this).children('.dropdown-menu');

        //根据会员级别判断是否可以切换国家
        chrome.storage.local.get({
          userInfo: {}, //用户信息
        }, function(items) {
          //金鹰,神鹰 才可选
          if ([6, 7].includes(items.userInfo.yys_member)) {
            if (child.is(':hidden')) {
              child.stop(true, false).show(200);
              $(this).siblings('.tip-li-source').children('.dropdown-menu').stop(true,
                false).hide(200);
            } else {
              child.stop(true, false).hide(200);
            }
            $(document).one('click', function() {
              $('.dropdown-menu').stop(true, false).hide(200);
            })
            //阻止事件冒泡触发事件导致隐藏
            e.stopPropagation();
          } else {
            layer.confirm('您的会员级别不权限使用当前功能，请升级更高版本。', {
              btn: ['立即购买'] //按钮
            }, function() {
              window.open(yysConfigs.buyYYsPagePath);
            })
          }
        })
      });
      //阻止点击内容时隐藏
      $('.dropdown-menu').on('click', function(e) {
        e.stopPropagation()
      })
    })(i)
  }
  // 点击国家下拉栏筛选
  $('#normalCountrySource').on('click', function() {
    //调用初始化精确国家方法
    init_sureCountrySource(1);
    $('.dropdown-menu').stop(true, false).hide(200);

    //清空城市框内容
    $(".sure-city #city").val("");
  });
};

/* 初始化精确国家数据type(0/不传:无默认选择 1:选中默认)  */
function init_sureCountry(type) {
  $('#sel1').html('亚洲');
  $('#sel2').html('欧洲');
  $('#sel3').html('美洲');
  $('#sel4').html('大洋洲');
  $('#sel5').html('非洲');
  $('.tip-li').removeClass('active');
  if (type == 1) {
    $('#normalCountry').addClass('active'); //选中默认
  }
}

function chooseMmFont(country) {
  if (country == "mm") {
    $("#search-text, #searchInput, title, .main .yys-content .info-content .info-list .info-intro, .main .yys-content .info-content .info-list .info-title .myTitle, .client-info .yys-infomation .info-content-box .more-info .selected #my-subject, .client-info .yys-infomation .info-content-box .more-info .selected #my-desc-info")
      .css("font-family", 'Noto Sans Myanmar');
  } else {
    $("#search-text, #searchInput, title, .main .yys-content .info-content .info-list .info-intro, .main .yys-content .info-content .info-list .info-title .myTitle, .client-info .yys-infomation .info-content-box .more-info .selected #my-subject, .client-info .yys-infomation .info-content-box .more-info .selected #my-desc-info")
      .css("font-family", 'PingFangSC-Light, "Microsoft YaHei", "Hiragino Sans GB", "WenQuanYi Micro Hei"');
  }
}

// 向content-script主动发送消息
function sendMessageToContentScript(message, callback) {
  chrome.tabs.query({
    active: true,
    currentWindow: true
  }, function(tabs) {
    chrome.tabs.sendMessage(tabs[0].id, message, function(response) {
      if (callback) callback(response);
    });
  });
}

// ********************************搜索框自动补全********************************
//自动补全城市
var selectedCityIndex = 0;
$(function() {
  $(".sure-city #city").on("keyup click", function(event) {
    if (event.keyCode != 13 && event.keyCode != 38 && event.keyCode != 40) {
      selectedCityIndex = 0;
    }
    var len = 0;
    var inputVal = $(this).val().trim();
    var temp = new Array();
    if (inputVal.length > 0) {
      //有输入值就匹配
      len = yysConfigs.cityItems.length;
      for (var i = 0; i < len; i++) {
        if (yysConfigs.cityItems[i].city.toLowerCase().indexOf(inputVal.toLowerCase()) != -1) {
          temp[temp.length] = yysConfigs.cityItems[i];
          if (temp.length >= 10) {
            break;
          }
        }
      }
    } else {
      //没有输入值就获取全部
      len = yysConfigs.cityItems.length;
      for (var i = 0; i < len; i++) {
        temp[temp.length] = yysConfigs.cityItems[i];
      }
    }
    len = temp.length;
    if (len > 0) {
      $(".sure-city .search-results").show();
      $(".sure-city .search-results").empty();
      for (var j = 0; j < len; j++) {
        $(".sure-city .search-results").append("<li id='result-row" + j +
          "' selectedCityIndex='" + j + "' enCity='" + temp[j].en_city + "'>" + temp[j]
          .city + "</li>");
      }

      switch (event.keyCode) {
        case 38:
          selectedCityIndex = selectedCityIndex == 0 ? len - 1 : selectedCityIndex - 1;
          break;
        case 40:
          selectedCityIndex = selectedCityIndex == len - 1 ? 0 : selectedCityIndex + 1;
          break;
        case 13:
          var val = $(".sure-city  .search-results #result-row" + selectedCityIndex).attr(
            "enCity");
          $(".sure-city #city").val(val)
          $(".sure-city  .search-results").hide();
          break;
      }

      $(".sure-city .search-results li").removeClass("selected-result");
      $(".sure-city .search-results #result-row" + selectedCityIndex).addClass("selected-result");
    } else {
      $(".sure-city .search-results").empty();
      $(".sure-city .search-results").hide();
    }
    event.stopPropagation();
  });

  $(".sure-city .search-results").on("mouseout mouseover keyup", "li", function() {
    $(".sure-city .search-results li").removeClass("selected-result");
    selectedCityIndex = parseInt($(this).attr("selectedCityIndex"));
    $(this).toggleClass("selected-result");
  });
  $(".sure-city  .search-results").on("click", "li", function() {
    $(".sure-city #city").val($(this).attr("enCity"));
    $(".sure-city .search-results").hide();
  });
});

//*****************************其它公共方法*****************************
// 数组去重
function unique(now_arr) {
  if (!Array.isArray(now_arr)) {
    return '';
  }
  return [...new Set(now_arr)];
}

//获取域名方法
function getUrlDomain(link) {
  var domain = "";
  if (!!link) {
    //防止拷贝问题
    let url = JSON.parse(JSON.stringify(link));
    domain = url;
    //获取域名
    if (!!domain && domain.indexOf("/") != -1) {
      domain = url.split("/")[2];
    }

    //判断域名中是否有www
    if (!!domain && domain.indexOf("www.") != -1) { //有就去掉www.
      console.log(domain);
      domain = domain.substring(4, domain.length)
    }
  }
  return domain;
}

//访问background.js的方法
chrome.extension.getBackgroundPage();
